// DissolveFilter.cpp : Implementation of CDissolveFilter

#include "stdafx.h"
#include "DissolveFilter.h"
#include <MultiLanguageString.h>
#include <RWDocumentImageRaster.h>


// CDissolveFilter

STDMETHODIMP CDissolveFilter::NameGet(IOperationManager* a_pManager, ILocalizedString** a_ppOperationName)
{
	// Using multi-languge string format: http://wiki.rw-designer.com/Localized_Strings
	// Feel free to use just plain English strings.
	*a_ppOperationName = new CMultiLanguageString(L"[0409]Raster Image - Dissolve[0405]Rastrov obrzek - rozputn");
	return S_OK;
}

STDMETHODIMP CDissolveFilter::ConfigCreate(IOperationManager* a_pManager, IConfig** a_ppDefaultConfig)
{
	*a_ppDefaultConfig = NULL;
	CComPtr<IConfigWithDependencies> pCfg;
	RWCoCreateInstance(pCfg, __uuidof(ConfigWithDependencies));
	pCfg->ItemInsRanged(
		CComBSTR(L"Amount"),
		CMultiLanguageString::GetAuto(L"[0409]Amount[0405]Mnostv"),
		CMultiLanguageString::GetAuto(L"[0409]Amount of deleted pixels in percents.[0405]Mnostv smazanch pixel v procentech."),
		CConfigValue(20.0f), NULL, // default
		CConfigValue(0.0f), CConfigValue(100.0f), CConfigValue(0.1f), // range and step
		0, NULL);
	pCfg->Finalize(NULL);
	*a_ppDefaultConfig = pCfg.Detach();
	return S_OK;
}

STDMETHODIMP CDissolveFilter::CanActivate(IOperationManager* a_pManager, IDocument* a_pDocument, IConfig* a_pConfig, IOperationContext* a_pContext)
{
	// TODO: check if the document supports the required interface
	return a_pDocument ? S_OK : S_FALSE;
}

STDMETHODIMP CDissolveFilter::Activate(IOperationManager* a_pManager, IDocument* a_pDocument, IConfig* a_pConfig, IOperationContext* a_pContext, RWHWND a_hParent, LCID a_tLocaleID)
{
	CComPtr<IDocumentRasterImage> pImg;
	a_pDocument->QueryFeatureInterface(__uuidof(IDocumentRasterImage), reinterpret_cast<void**>(&pImg));
	if (pImg == NULL)
		return E_NOINTERFACE;

	CConfigValue cAmount;
	a_pConfig->ItemValueGet(CComBSTR(L"Amount"), &cAmount);
	long nLimit = 0x1000000 * (cAmount.operator float()*0.01f);

	TRasterImageCoord tSize = {0, 0, 0, 0};
	pImg->SizeGet(&tSize);
	ULONG nPixels = tSize.n0*tSize.n1*tSize.n2*tSize.n3;
	CAutoVectorPtr<TRasterImagePixel> pBuffer;
	if (!pBuffer.Allocate(nPixels))
		return E_FAIL;
	static TRasterImageCoord const tOrig = {0, 0, 0, 0};
	pImg->RectangleGet(&tOrig, &tSize, nPixels, pBuffer);
	static TRasterImagePixel const tEmpty = {0, 0, 0, 0};

	enum
	{
		// random number generator
		MODULUS = 2147483647,
		MULTIPLIER = 48271,
		CHECK = 399268537,
		A256 = 22925,
		DEFAULT = 123456789,
	};
	static long const Q = MODULUS / MULTIPLIER;
	static long const R = MODULUS % MULTIPLIER;
	long nRandom = DEFAULT;

	TRasterImagePixel* p = pBuffer;
	for (TRasterImagePixel* pEnd = p+nPixels; p < pEnd; ++p)
	{
		// get pseudo random number
        long t = MULTIPLIER * (nRandom % Q) - R * (nRandom / Q);
		nRandom = t > 0 ? t : (t + MODULUS);
		if ((nRandom&0xffffff) < nLimit)
			*p = tEmpty;
	}
	return pImg->RectangleSet(&tOrig, &tSize, nPixels, pBuffer);
}

// the following methods define a menu item

STDMETHODIMP CDissolveFilter::Name(ILocalizedString** a_ppName)
{
	*a_ppName = new CMultiLanguageString(L"[0409]Dissolve...[0405]Rozputn...");
	return S_OK;
}

STDMETHODIMP CDissolveFilter::Description(ILocalizedString** a_ppDesc)
{
	*a_ppDesc = new CMultiLanguageString(L"[0409]Make given percentage of pixels in the image transparent.[0405]Smazat z obrzku dan procento pixel.");
	return S_OK;
}

STDMETHODIMP CDissolveFilter::IconID(GUID* a_pIconID)
{
	return E_NOTIMPL;
}

STDMETHODIMP CDissolveFilter::Accelerator(TCmdAccel* a_pAccel, TCmdAccel* a_pAuxAccel)
{
	return E_NOTIMPL;
}

STDMETHODIMP CDissolveFilter::Configuration(IConfig* a_pOperationCfg)
{
	// Adjust operation configuration of the menu item.
	// Use GUID of the Display Configuration operation
	// and make the Amount paremeter configurable.

	// "Operation" is a hardcoded ID of the root configuration item
	// and you must set it to the GUID of the main operation.
	CComBSTR bstr1(L"Operation");
	// It is set to __uuidof(DocumentOperationShowConfig), because
	// we want a configuration dialog. If no configuration dialog
	// is necessary, just set it to GUID of your operation.
	CConfigValue cID1(__uuidof(DocumentOperationShowConfig));

	// Since I am using the "Show Configuration" operation
	// http://wiki.rw-designer.com/Operation_Display_Configuration
	// (selected in previous step), I'll have to set its internals.
	// First, the actual operation used (this very "Dissolve" op).
	CComBSTR bstr2(L"Operation\\CfgOperation");
	CConfigValue cID2(__uuidof(DissolveFilter));

	// dialog window caption
	CComBSTR bstr3(L"Operation\\Caption");
	CConfigValue cID3(L"[0409]Configure Dissolve[0405]Konfigurovat rozputn");

	// use single slider as configuration
	CComBSTR bstr4(L"Operation\\Parameter");
	CConfigValue cID4(L"Amount");

	// select view for preview
	CComBSTR bstr5(L"Operation\\Preview");
	// http://wiki.rw-designer.com/Image_-_Viewer
	static const GUID tImageViewer = {0x9432886a, 0xd01d, 0x40f1, {0x99, 0x7c, 0x0b, 0x8f, 0x7a, 0x72, 0x2b, 0xfa}};
	CConfigValue cID5(tImageViewer);

	// turn on auto-refresh
	CComBSTR bstr6(L"Operation\\AutoUpdate");
	CConfigValue cID6(true);

	//// TODO: create custom help string
	//CComBSTR bstr7(L"Operation\\HelpTopic");
	//CConfigValue cID7(L"Dissolve deletes given percentage of pixels from image.<br><a href=\" link to a page with documentation \">More information</a>");

	// now, set all those values
	BSTR aIDs[] = {bstr1.m_str, bstr2.m_str, bstr3.m_str, bstr4.m_str, bstr5.m_str, bstr6.m_str};
	TConfigValue aVals[] = {cID1, cID2, cID3, cID4, cID5, cID6};
	return a_pOperationCfg->ItemValuesSet(sizeof(aIDs)/sizeof(*aIDs), aIDs, aVals);
}

