#pragma once

#ifdef __cplusplus

class CImageFormat
{
public:
	CImageFormat()
	{
		ZeroMemory(&m_tIF, sizeof(m_tIF));
		m_tIF.atDims[0].nItems = m_tIF.atDims[1].nItems = m_tIF.atDims[2].nItems = m_tIF.atDims[3].nItems = 1;
		m_tIF.atDims[0].nAlignment = m_tIF.atDims[1].nAlignment = m_tIF.atDims[2].nAlignment = m_tIF.atDims[3].nAlignment = 1;
	}
	CImageFormat(const TImageFormat& a_tIF) : m_tIF(a_tIF)
	{
		Normalize();
	}
	CImageFormat(ULONG a_nWidth, ULONG a_nHeight, ULONG a_nBPP, BYTE a_nBlueBits, BYTE a_nGreenBits, BYTE a_nRedBits)
	{
		ZeroMemory(&m_tIF, sizeof(m_tIF));
		m_tIF.dwFormatID = EImgFmtRAW;
		m_tIF.dwFormatParameter = 0;
		m_tIF.nDataSize = (((a_nWidth*a_nBPP+31)>>5)<<2) * a_nHeight;
		m_tIF.nPixelSize = a_nBPP;
		m_tIF.atDims[0].nItems = a_nWidth;
		m_tIF.atDims[0].nAlignment = 4;
		m_tIF.atDims[1].nItems = a_nHeight;
		m_tIF.atDims[1].nAlignment = 4;
		m_tIF.atPSps[0].eCCHint = ECCBlue;
		m_tIF.atPSps[0].nOffset = 0;
		m_tIF.atPSps[0].nWidth = a_nBlueBits;
		m_tIF.atPSps[1].eCCHint = ECCGreen;
		m_tIF.atPSps[1].nOffset = 0;
		m_tIF.atPSps[1].nWidth = a_nGreenBits;
		m_tIF.atPSps[2].eCCHint = ECCRed;
		m_tIF.atPSps[2].nOffset = 0;
		m_tIF.atPSps[2].nWidth = a_nRedBits;
	}

	CImageFormat& operator =(const TImageFormat& a_tOrig)
	{
		m_tIF = a_tOrig;
		Normalize();
		return *this;
	}
	CImageFormat& operator =(const CImageFormat& a_cOrig)
	{
		m_tIF = a_cOrig.m_tIF;
		return *this;
	}

	operator const TImageFormat&() const
	{
		return m_tIF;
	}
	operator const TImageFormat*() const
	{
		return &m_tIF;
	}
	operator TImageFormat*()
	{
		return &m_tIF;
	}

	const TImageFormat* operator->() const
	{ 
		return &m_tIF;
	}

	TImageFormat* operator->()
	{ 
		return &m_tIF;
	}

	// comparisons
	bool IsSameSize(const TImageFormat& a_tIF) const
	{
		return m_tIF.atDims[0].nItems == a_tIF.atDims[0].nItems &&
			   m_tIF.atDims[1].nItems == a_tIF.atDims[1].nItems &&
			   m_tIF.atDims[2].nItems == a_tIF.atDims[2].nItems &&
			   m_tIF.atDims[3].nItems == a_tIF.atDims[3].nItems;
	}
	bool IsCompatibleSizeAndAlignment(const TImageFormat& a_tIF) const
	{
		if (!IsSameSize(a_tIF))
			return false;

		ULONG nSize1 = (m_tIF.nPixelSize+7)>>3;
		ULONG nSize2 = (a_tIF.nPixelSize+7)>>3;
		int i;
		for (i = 0; i < 4 && m_tIF.atDims[i].nItems; i++)
		{
			nSize1 = ((nSize1*m_tIF.atDims[i].nItems + m_tIF.atDims[i].nAlignment - 1) / m_tIF.atDims[i].nAlignment) * m_tIF.atDims[i].nAlignment;
			nSize2 = ((nSize2*a_tIF.atDims[i].nItems + a_tIF.atDims[i].nAlignment - 1) / a_tIF.atDims[i].nAlignment) * a_tIF.atDims[i].nAlignment;
			if (nSize1 != nSize2)
				return false;
		}
		return true;
	}
	bool IsSameSizeAndAlignment(const TImageFormat& a_tIF) const
	{
		return IsSameSize(a_tIF) &&
			   m_tIF.atDims[0].nAlignment == a_tIF.atDims[0].nAlignment &&
			   m_tIF.atDims[1].nAlignment == a_tIF.atDims[1].nAlignment &&
			   m_tIF.atDims[2].nAlignment == a_tIF.atDims[2].nAlignment &&
			   m_tIF.atDims[3].nAlignment == a_tIF.atDims[3].nAlignment;
	}
	bool IsSamePixelFormat(const CImageFormat& a_cIF) const // CImageFormat is always normalized
	{
		return m_tIF.nPixelSize == a_cIF.m_tIF.nPixelSize &&
			   m_tIF.atPSps[0].nOffset == a_cIF.m_tIF.atPSps[0].nOffset &&
			   m_tIF.atPSps[0].nWidth == a_cIF.m_tIF.atPSps[0].nWidth &&
			   m_tIF.atPSps[1].nOffset == a_cIF.m_tIF.atPSps[1].nOffset &&
			   m_tIF.atPSps[1].nWidth == a_cIF.m_tIF.atPSps[1].nWidth &&
			   m_tIF.atPSps[2].nOffset == a_cIF.m_tIF.atPSps[2].nOffset &&
			   m_tIF.atPSps[2].nWidth == a_cIF.m_tIF.atPSps[2].nWidth &&
			   m_tIF.atPSps[3].nOffset == a_cIF.m_tIF.atPSps[3].nOffset &&
			   m_tIF.atPSps[3].nWidth == a_cIF.m_tIF.atPSps[3].nWidth &&
			   (m_tIF.atPSps[0].eCCHint == a_cIF.m_tIF.atPSps[0].eCCHint ||
			    m_tIF.atPSps[0].eCCHint == ECCUnknown || a_cIF.m_tIF.atPSps[0].eCCHint == ECCUnknown) &&
			   (m_tIF.atPSps[1].eCCHint == a_cIF.m_tIF.atPSps[1].eCCHint ||
			    m_tIF.atPSps[1].eCCHint == ECCUnknown || a_cIF.m_tIF.atPSps[1].eCCHint == ECCUnknown) &&
			   (m_tIF.atPSps[2].eCCHint == a_cIF.m_tIF.atPSps[2].eCCHint ||
			    m_tIF.atPSps[2].eCCHint == ECCUnknown || a_cIF.m_tIF.atPSps[2].eCCHint == ECCUnknown) &&
			   (m_tIF.atPSps[3].eCCHint == a_cIF.m_tIF.atPSps[3].eCCHint ||
			    m_tIF.atPSps[3].eCCHint == ECCUnknown || a_cIF.m_tIF.atPSps[3].eCCHint == ECCUnknown);
	}

	bool HasChannel(WORD a_eChannel)
	{
		int i;
		for (i = 0; i < 4; i++)
		{
			if (m_tIF.atPSps[i].eCCHint == a_eChannel)
				return m_tIF.atPSps[i].nWidth != 0;
		}
		return false;
	}

	ULONG GetDimSize(int a_nDim) const
	{
		ULONG nTmp = m_tIF.nPixelSize;
		int i;
		for (i = 0; i < a_nDim && m_tIF.atDims[i].nItems; i++)
		{
			nTmp = ((nTmp*m_tIF.atDims[i].nItems + (m_tIF.atDims[i].nAlignment<<3) - 1) / (m_tIF.atDims[i].nAlignment<<3)) * (m_tIF.atDims[i].nAlignment<<3);
		}
		return (nTmp + 7)>>3;
	}

	// sorts the pixel specs according to order of components
	void Normalize()
	{
		int i;
		for (i = 0; i < 3; i++)
		{
			int j;
			for (j = 0; j < (3-i); j++)
			{
				if (m_tIF.atPSps[j+1].nWidth && m_tIF.atPSps[j].nOffset > m_tIF.atPSps[j].nOffset)
				{
					TPixelSpec tTmp = m_tIF.atPSps[j+1];
					m_tIF.atPSps[j+1] = m_tIF.atPSps[j];
					m_tIF.atPSps[j] = tTmp;
				}
			}
		}
	}

protected:

private:
	TImageFormat m_tIF;
};

#endif//__cplusplus

