#pragma once

#ifdef __cplusplus

// wrapper for plug-in CLSID enumeration
// CATID_PlugIn - CATID of the plug-in category to enumerate
// t_dwTimeout - time in milliseconds the enumerated information
//               is considered valid (default - never expires)
template<const CATID* CATID_PlugIn, DWORD t_dwTimeout = 0xffffffff>
class CPlugInCLSIDCache
{
public:
	typedef std::vector<CLSID> ACLSIDs;

	CPlugInCLSIDCache()
	{
	}

	operator const ACLSIDs&() const
	{
		CComPtr<IPlugInCache> pManager;
		RWCoCreateInstance(pManager, __uuidof(PlugInCache));

		m_aCLSIDs.clear();
		CComPtr<IEnumGUIDs> pTmp;
		pManager->CLSIDsEnum(*CATID_PlugIn, t_dwTimeout, &pTmp);
		ULONG i;
		CLSID tCLSID;
		for (i = 0; SUCCEEDED(pTmp->Get(i, &tCLSID)); i++)
		{
			m_aCLSIDs.push_back(tCLSID);
		}

		return m_aCLSIDs;
	}

private:
	mutable ACLSIDs m_aCLSIDs; // mutable - optimization
};

template<const CATID* CATID_PlugIn, class IPlugIn, DWORD t_dwTimeout = 0xffffffff>
class CPlugInObjectCache
{
public:
	typedef std::vector<CComPtr<IPlugIn> > AIPlugIns;
	typedef std::vector<std::pair<CComPtr<IPlugIn>, CLSID> > AIPlugInsAndCLSIDs;

	CPlugInObjectCache()
	{
	}

	void GetPlugIns(AIPlugIns& a_cPlugIns) const
	{
		CComPtr<IPlugInCache> pManager;
		RWCoCreateInstance(pManager, __uuidof(PlugInCache));

		a_cPlugIns.clear();
		CComPtr<IEnumUnknowns> pTmp;
		CComPtr<IEnumGUIDs> pTmpCLSIDs;
		pManager->InterfacesEnum(*CATID_PlugIn, __uuidof(IPlugIn), t_dwTimeout, &pTmp, &pTmpCLSIDs);
		ULONG i;
		CComPtr<IPlugIn> pPlugIn;
		CLSID tCLSID;
		for (i = 0; SUCCEEDED(pTmp->Get(i, __uuidof(IPlugIn), reinterpret_cast<void**>(&pPlugIn))) && SUCCEEDED(pTmpCLSIDs->Get(i, &tCLSID)); i++)
		{
			a_cPlugIns.push_back(pPlugIn);
			pPlugIn = NULL;
		}
	}
	void GetPlugIns(AIPlugInsAndCLSIDs& a_cPlugIns) const
	{
		CComPtr<IPlugInCache> pManager;
		RWCoCreateInstance(pManager, __uuidof(PlugInCache));

		a_cPlugIns.clear();
		CComPtr<IEnumUnknowns> pTmp;
		CComPtr<IEnumGUIDs> pTmpCLSIDs;
		pManager->InterfacesEnum(*CATID_PlugIn, __uuidof(IPlugIn), t_dwTimeout, &pTmp, &pTmpCLSIDs);
		ULONG i;
		CComPtr<IPlugIn> pPlugIn;
		CLSID tCLSID;
		for (i = 0; SUCCEEDED(pTmp->Get(i, __uuidof(IPlugIn), reinterpret_cast<void**>(&pPlugIn))) && SUCCEEDED(pTmpCLSIDs->Get(i, &tCLSID)); i++)
		{
			a_cPlugIns.push_back(make_pair(pPlugIn, tCLSID));
			pPlugIn = NULL;
		}
	}
};

#endif//__cplusplus

