#pragma once

#ifdef __cplusplus

} // pause: extern "C"{

template<class IInterface>
class CEnumInterfaces
{
public:
	CEnumInterfaces() : m_pEU(NULL)
	{
	}
	CEnumInterfaces(IEnumUnknowns *a_pEU) : m_pEU(a_pEU)
	{
		if (m_pEU) m_pEU->AddRef();
	}
	CEnumInterfaces(CEnumInterfaces& a_cOrig) : m_pEU(a_cOrig.m_pEU)
	{
		if (m_pEU) m_pEU->AddRef();
	}

	~CEnumInterfaces()
	{
		if (m_pEU) m_pEU->Release();
	}

	IEnumUnknowns** operator&()
	{
		ATLASSERT(m_pEU == NULL);
		return &m_pEU;
	}

	HRESULT Size(ULONG *a_pnSize)
	{
		ATLASSERT(m_pEU);
		return m_pEU->Size(a_pnSize);
	}

	HRESULT Get(ULONG a_nIndex, IInterface** a_ppItem)
	{
		ATLASSERT(m_pEU);
		return m_pEU->Get(a_nIndex, __uuidof(IInterface), reinterpret_cast<void**>(a_ppItem));
	}

	HRESULT GetMultiple(ULONG a_nIndexFirst, ULONG a_nCount, IInterface** a_apItems)
	{
		ATLASSERT(m_pEU);
		return m_pEU->Get(a_nIndex, a_nCount, __uuidof(IInterface), reinterpret_cast<void**>(a_apItems));
	}

private:
	IEnumUnknowns *m_pEU;
};

template<typename TStruct>
class CEnumStructs
{
public:
	CEnumStructs() : m_p(NULL)
	{
	}
	~CEnumStructs()
	{
		if (m_p) m_p->Release();
	}

	CEnumStructs const& operator=(IEnumStructs* a_p)
	{
		if (m_p != a_p)
		{
			if (m_p) m_p->Release();
			if (a_p) a_p->AddRef();
			m_p = a_p;
		}
		return *this;
	}
	CEnumStructs const& operator=(CEnumStructs const& a_p)
	{
		if (m_p != a_p.m_p)
		{
			if (m_p) m_p->Release();
			if (a_p.m_p) a_p.m_p->AddRef();
			m_p = a_p.m_p;
		}
		return *this;
	}
	void Attach(IEnumStructs* a_p)
	{
		if (m_p) m_p->Release();
		m_p = a_p;
	}
	IEnumStructs* Detach()
	{
		IEnumStructs* p = m_p;
		m_p = NULL;
		return p;
	}

	IEnumStructs** operator&()
	{
		ATLASSERT(m_p == NULL);
		return &m_p;
	}

	HRESULT Size(ULONG* a_nCount)
	{
		if (m_p == NULL)
			return 0;
		return m_p->Size(sizeof(TStruct), a_nCount);
	}
	HRESULT Get(ULONG a_nIndex, TStruct* a_pItem)
	{
		ATLASSERT(m_p);
		return m_p->Get(a_nIndex, sizeof(TStruct), reinterpret_cast<BYTE*>(a_pItem));
	}
	HRESULT GetMultiple(ULONG a_nIndexFirst, ULONG a_nCount, TStruct* a_aItem)
	{
		ATLASSERT(m_p);
		return m_p->GetMultiple(a_nIndexFirst, a_nCount, sizeof(TStruct), reinterpret_cast<BYTE*>(a_aItem));
	}

private:
	IEnumStructs* m_p;
};

extern "C"{ // continue: extern "C"{

#endif//__cplusplus

