
#pragma once

#ifdef __cplusplus

} // pause: extern "C"{


template<UINT t_nIDSName, UINT t_nIDSDesc, UINT t_nIDI, UINT t_nIDSCategory, size_t t_nFeatures, IID const* t_apFeatures, class TBase = IDocumentCreator>
class CDocumentCreatorSingleImpl : public TBase
{
	// IDocumentCreator methods
public:
	STDMETHOD(DefaultConfig)(IConfig** UNREF(a_ppConfig))
	{
		return E_NOTIMPL;
	}
	STDMETHOD(Size)(ULONG* a_pnCount)
	{
		try
		{
			*a_pnCount = 1;
			return S_OK;
		}
		catch (...)
		{
			return a_pnCount == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}

	STDMETHOD(Name)(ULONG a_nIndex, ILocalizedString** a_ppName)
	{
		try
		{
			*a_ppName = NULL;
			if (a_nIndex != 0)
				return E_RW_INDEXOUTOFRANGE;

			*a_ppName = _SharedStringTable.GetString(t_nIDSName);

			return S_OK;
		}
		catch (...)
		{
			return a_ppName == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
	STDMETHOD(HelpText)(ULONG a_nIndex, ILocalizedString** a_ppHelpText)
	{
		try
		{
			*a_ppHelpText = NULL;
			if (a_nIndex != 0)
				return E_RW_INDEXOUTOFRANGE;

			*a_ppHelpText = _SharedStringTable.GetString(t_nIDSDesc);

			return S_OK;
		}
		catch (...)
		{
			return a_ppHelpText == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
	STDMETHOD(Icon)(ULONG a_nIndex, ULONG a_nSize, HICON* a_phIcon)
	{
		try
		{
			*a_phIcon = 0;
			if (a_nIndex != 0)
				return E_RW_INDEXOUTOFRANGE;

			*a_phIcon = (HICON)::LoadImage(_pModule->get_m_hInst(), MAKEINTRESOURCE(t_nIDI), IMAGE_ICON, a_nSize, a_nSize, LR_DEFAULTCOLOR);
			return S_OK;
		}
		catch (...)
		{
			return a_phIcon == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}

	STDMETHOD(Category)(ULONG a_nIndex, ILocalizedString** a_ppCategory)
	{
		try
		{
			*a_ppCategory = 0;
			if (a_nIndex != 0)
				return E_RW_INDEXOUTOFRANGE;

			*a_ppCategory = _SharedStringTable.GetString(t_nIDSCategory);

			return S_OK;
		}
		catch (...)
		{
			return a_ppCategory == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}

	STDMETHOD(CheckFeatures)(ULONG a_nIndex, ULONG a_nCount, const IID* a_aiidRequired)
	{
		try
		{
			if (a_nIndex != 0)
				return E_RW_INDEXOUTOFRANGE;

			return SupportsAllFeatures(t_nFeatures, t_apFeatures, a_nCount, a_aiidRequired) ? S_OK : E_NOINTERFACE;
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}
};

extern "C"{ // continue: extern "C"{

#endif//__cplusplus