
#pragma once

#ifdef __cplusplus

} // pause: extern "C"{

template<class TBase>
class ATL_NO_VTABLE CTriangleMeshImpl : public TBase
{
public:
	STDMETHOD(VertexStatePack)(ULONG a_nVertexIDs, ULONG const* a_aVertexIDs, ISharedState** a_ppState)
	{
		try
		{
			*a_ppState = NULL;
			CComObject<CPackedState<IEnumUInts, ULONG> >* p = NULL;
			CComObject<CPackedState<IEnumUInts, ULONG> >::CreateInstance(&p);
			CComPtr<ISharedState> pTmp = p;
			p->Init(a_aVertexIDs, a_aVertexIDs+a_nVertexIDs);
			*a_ppState = pTmp.Detach();
			return S_OK;
		}
		catch (...)
		{
			return a_ppState == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
	STDMETHOD(VertexStateUnpack)(ISharedState* a_pState, IEnumUInts** a_ppVertexIDs)
	{
		try
		{
			return a_pState->QueryInterface(a_ppVertexIDs);
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}
	STDMETHOD(TriangleStatePack)(ULONG a_nTriangles, TTriangleMeshTriangle const* a_aTriangles, ISharedState** a_ppState)
	{
		try
		{
			*a_ppState = NULL;
			CComObject<CPackedState<IEnumStructs, TTriangleMeshTriangle> >* p = NULL;
			CComObject<CPackedState<IEnumStructs, TTriangleMeshTriangle> >::CreateInstance(&p);
			CComPtr<ISharedState> pTmp = p;
			p->Init(a_aTriangles, a_aTriangles+a_nTriangles);
			*a_ppState = pTmp.Detach();
			return S_OK;
		}
		catch (...)
		{
			return a_ppState == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
	STDMETHOD(TriangleStateUnpack)(ISharedState* a_pState, IEnumStructs** a_ppTriangles)
	{
		try
		{
			return a_pState->QueryInterface(a_ppTriangles);
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}

private:
	template<class IEnumXxx, typename TItem>
	class CPackedState :
		public CComObjectRootEx<CComMultiThreadModel>,
		public ISharedState,
		public IEnumXxx
	{
	public:
		CPackedState() : m_aItems(NULL), m_nItems(0)
		{
		}
		~CPackedState()
		{
			delete[] m_aItems;
		}
		void Init(TItem const* a_pBegin, TItem const* a_pEnd)
		{
			m_nItems = a_pEnd-a_pBegin;
			if (m_nItems != 0)
			{
				m_aItems = new TItem[a_pEnd-a_pBegin];
				for (TItem* i = m_aItems; a_pBegin != a_pEnd; ++a_pBegin, ++i)
				{
					*i = *a_pBegin;
				}
			}
		}

	BEGIN_COM_MAP(CPackedState)
		COM_INTERFACE_ENTRY(ISharedState)
		COM_INTERFACE_ENTRY(IEnumXxx)
	END_COM_MAP()

		// ISharedState methods
	public:
		STDMETHOD(CLSIDGet)(CLSID* /*a_pCLSID*/)
		{
			return E_NOTIMPL;
		}
		STDMETHOD(ToText)(BSTR* a_pbstrText)
		{
			return E_NOTIMPL;
		}
		STDMETHOD(FromText)(BSTR a_bstrText)
		{
			return E_NOTIMPL;
		}

		// IEnumXxx
	public:
		STDMETHOD(Size)(ULONG *a_pnSize)
		{
			try
			{
				*a_pnSize = static_cast<ULONG>(m_nItems);
				return S_OK;
			}
			catch (...)
			{
				return E_POINTER;
			}
		}
		STDMETHOD(Get)(ULONG a_nIndex, TItem* a_pxItem)
		{
			try
			{
				if (a_nIndex >= m_nItems)
					return E_RW_INDEXOUTOFRANGE;

				*a_pxItem = m_aItems[a_nIndex];

				return S_OK;
			}
			catch (...)
			{
				return a_pxItem == NULL ? E_POINTER : E_UNEXPECTED;
			}
		}
		STDMETHOD(GetMultiple)(ULONG a_nIndexFirst, ULONG a_nCount, TItem* a_axItems)
		{
			try
			{
				if ((a_nIndexFirst+a_nCount) > m_nItems)
					return E_RW_INDEXOUTOFRANGE;

				for (TItem const* i = m_aItems + a_nIndexFirst; a_nCount; a_nCount--, ++i, ++a_axItems)
				{
					*a_axItems = *i;
				}

				return S_OK;
			}
			catch (...)
			{
				return a_axItems == NULL ? E_POINTER : E_UNEXPECTED;
			}
		}
		// -struct methods
		STDMETHOD(Size)(ULONG a_nStructSize, ULONG *a_pnSize)
		{
			if (a_nStructSize != sizeof(TItem))
				return E_FAIL;
			return Size(a_pnSize);
		}
		STDMETHOD(Get)(ULONG a_nIndex, ULONG a_nStructSize, BYTE* a_pItem)
		{
			if (a_nStructSize != sizeof(TItem))
				return E_FAIL;
			return Get(a_nIndex, reinterpret_cast<TItem*>(a_pItem));
		}
		STDMETHOD(GetMultiple)(ULONG a_nIndexFirst, ULONG a_nCount, ULONG a_nStructSize, BYTE* a_aItems)
		{
			if (a_nStructSize != sizeof(TItem))
				return E_FAIL;
			return GetMultiple(a_nIndexFirst, a_nCount, reinterpret_cast<TItem*>(a_aItems));
		}

	private:
		TItem* m_aItems;
		size_t m_nItems;
	};
};

extern "C"{ // continue: extern "C"{

#endif//__cplusplus
