#pragma once

#ifdef __cplusplus

class CImageLayerCreatorStorage :
	public IImageLayerCreator
{
public:
	CImageLayerCreatorStorage(IStorageFilter* a_pFile) : m_pFile(a_pFile)
	{
	}

	// IUnknown methods
public:
	STDMETHOD(QueryInterface)(REFIID a_riid, void** a_ppvObject)
	{
		if (IsEqualIID(a_riid, IID_IUnknown) || IsEqualIID(a_riid, __uuidof(IImageLayerCreator)))
		{
			*a_ppvObject = this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}
	STDMETHOD_(ULONG, AddRef)() { return 2; }
	STDMETHOD_(ULONG, Release)() { return 1; }

	// IImageLayerCreator methods
public:
	STDMETHOD(Create)(BSTR a_bstrID, IDocumentBaseInit* a_pBase)
	{
		CComPtr<IInputManager> pIM;
		RWCoCreateInstance(pIM, __uuidof(InputManager));
		return pIM->DocumentCreateData(1, &__uuidof(IDocumentImage), m_pFile, a_bstrID, a_pBase);
	}

private:
	CComPtr<IStorageFilter> m_pFile;
};


class CImageLayerCreatorWizard :
	public IImageLayerCreator
{
public:
	CImageLayerCreatorWizard(REFGUID a_tWizardGUID, ULONG a_nWizardIndex) : m_tWizardGUID(a_tWizardGUID), m_nWizardIndex(a_nWizardIndex)
	{
	}

	// IUnknown methods
public:
	STDMETHOD(QueryInterface)(REFIID a_riid, void** a_ppvObject)
	{
		if (IsEqualIID(a_riid, IID_IUnknown) || IsEqualIID(a_riid, __uuidof(IImageLayerCreator)))
		{
			*a_ppvObject = this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}
	STDMETHOD_(ULONG, AddRef)() { return 2; }
	STDMETHOD_(ULONG, Release)() { return 1; }

	// IImageLayerCreator methods
public:
	STDMETHOD(Create)(BSTR a_bstrID, IDocumentBaseInit* a_pBase)
	{
		CComPtr<IDocumentCreator> pDC;
		RWCoCreateInstance(pDC, m_tWizardGUID);
		if (pDC == NULL)
			return E_FAIL;
		return pDC->DocumentCreate(m_nWizardIndex, NULL, 0, NULL, a_bstrID, a_pBase);
	}

private:
	REFGUID m_tWizardGUID;
	ULONG m_nWizardIndex;
};


class CImageLayerCreatorDocument :
	public IImageLayerCreator
{
public:
	CImageLayerCreatorDocument(IDocument* a_pDoc) : m_pDoc(a_pDoc)
	{
	}
	CImageLayerCreatorDocument(IDocumentLayeredImage* a_pDoc, IComparable* a_pLayer) : m_pDoc(NULL)
	{
		CComPtr<ISubDocumentID> pSDI;
		a_pDoc->ItemFeatureGet(a_pLayer, __uuidof(ISubDocumentID), reinterpret_cast<void**>(&pSDI));
		pSDI->SubDocumentGet(&m_pDoc);
	}

	// IUnknown methods
public:
	STDMETHOD(QueryInterface)(REFIID a_riid, void** a_ppvObject)
	{
		if (IsEqualIID(a_riid, IID_IUnknown) || IsEqualIID(a_riid, __uuidof(IImageLayerCreator)))
		{
			*a_ppvObject = this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}
	STDMETHOD_(ULONG, AddRef)() { return 2; }
	STDMETHOD_(ULONG, Release)() { return 1; }

	// IImageLayerCreator methods
public:
	STDMETHOD(Create)(BSTR a_bstrID, IDocumentBaseInit* a_pBase)
	{
		return m_pDoc->DocumentCopy(EDCHDefault, a_bstrID, a_pBase);
	}

private:
	CComPtr<IDocument> m_pDoc;
};

class CImageLayerCreatorRasterImage :
	public IImageLayerCreator
{
public:
	CImageLayerCreatorRasterImage(TRasterImageCoord const& a_tSize, ULONG a_nPixels, TRasterImagePixel const* a_pPixels) :
		m_tSize(a_tSize), m_nPixels(a_nPixels), m_pPixels(a_pPixels)
	{
	}

	// IUnknown methods
public:
	STDMETHOD(QueryInterface)(REFIID a_riid, void** a_ppvObject)
	{
		if (IsEqualIID(a_riid, IID_IUnknown) || IsEqualIID(a_riid, __uuidof(IImageLayerCreator)))
		{
			*a_ppvObject = this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}
	STDMETHOD_(ULONG, AddRef)() { return 2; }
	STDMETHOD_(ULONG, Release)() { return 1; }

	// IImageLayerCreator methods
public:
	STDMETHOD(Create)(BSTR a_bstrID, IDocumentBaseInit* a_pBase)
	{
		CComPtr<IDocumentFactoryRasterImage> pFct;
		RWCoCreateInstance(pFct, __uuidof(DocumentFactoryRasterImage));
		return pFct->Create(&m_tSize, m_nPixels, m_pPixels, ERIAMAuto, a_bstrID, a_pBase);
	}

private:
	TRasterImageCoord m_tSize;
	ULONG m_nPixels;
	TRasterImagePixel const* m_pPixels;
};

#endif//__cplusplus

