
#pragma once

#ifdef __cplusplus

} // pause: extern "C"{


template<class T, size_t t_nFeatures, IID const* t_apFeatures, class TDocumentTypeCreator, EUndoMode a_tDefaultUndoMode = EUMDefault, class TBase = IDocumentData>
class ATL_NO_VTABLE CDocumentDataImpl : public TBase
{
public:
	typedef CDocumentDataImpl<T, t_nFeatures, t_apFeatures, TDocumentTypeCreator, a_tDefaultUndoMode, TBase> DataImplClass;
	typedef CReadLock<DataImplClass> CDocumentReadLock;
	typedef CWriteLock<DataImplClass> CDocumentWriteLock;

	CDocumentDataImpl()
	{
	}

	//IStorageFilter* M_Location() const // must be locked externally
	//{
	//	return m_pLocation;
	//}

	HRESULT WriteLock()		{ return m_pBase ? m_pBase->WriteLock() : S_OK; }
	HRESULT WriteUnlock()	{ return m_pBase ? m_pBase->WriteUnlock() : S_OK; }
	HRESULT ReadLock()		{ return m_pBase ? m_pBase->ReadLock() : S_OK; }
	HRESULT ReadUnlock()	{ return m_pBase ? m_pBase->ReadUnlock() : S_OK; }
	HRESULT UndoEnabled() const	{ return m_pBase ? m_pBase->UndoEnabled() : S_FALSE; }
	HRESULT UndoStep(IDocumentUndoStep* a_pStep)
	{ return m_pBase ? m_pBase->UndoStep(a_pStep) : E_UNEXPECTED; }

	// IDocumentData methods
public:
	STDMETHOD(Init)(IDocumentBase* a_pCallback, BSTR a_bstrID)
	{
		m_pBase = a_pCallback;
		m_bstrDataID = a_bstrID;
		return S_OK;
	}
	STDMETHOD(FeaturesGetCount)(ULONG *a_pnCount)
	{
		try
		{
			*a_pnCount = t_nFeatures;
			return S_OK;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}
	STDMETHOD(FeaturesGet)(ULONG a_nIndexFirst, ULONG a_nCount, GUID* a_atFeatures)
	{
		try
		{
			if ((a_nIndexFirst+a_nCount) > t_nFeatures)
				return E_RW_INDEXOUTOFRANGE;

			for (IID const* i = t_apFeatures+a_nIndexFirst; a_nCount != 0; a_nCount--)
			{
				*(a_atFeatures++) = *(i++);
			}

			return S_OK;
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}

	STDMETHOD(DataCopy)(EDocumentCopyHint /*a_eHint*/, BSTR /*a_bstrPrefix*/, IDocumentBaseInit* /*a_pBase*/)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(DocumentTypeGet)(IDocumentType** a_ppDocumentType)
	{
		try
		{
			*a_ppDocumentType = TDocumentTypeCreator::Create();
			return *a_ppDocumentType ? S_OK : E_NOTIMPL;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}

	STDMETHOD(SaveOptionsGet)(IConfig** a_ppSaveOptions, IEnumUnknowns** a_ppFormatFilters, IStorageFilterWindowListener** a_ppWindowListener)
	{
		try
		{
			if (a_ppSaveOptions)
				*a_ppSaveOptions = NULL;
			if (a_ppWindowListener)
				*a_ppWindowListener = NULL;
			if (a_ppFormatFilters)
			{
				*a_ppFormatFilters = NULL;
				CComPtr<IEnumUnknownsInit> pFlts;
				CComPtr<IDocumentType> pDocType;
				static_cast<T*>(this)->DocumentTypeGet(&pDocType);
				if (pDocType != NULL)
				{
					RWCoCreateInstance(pFlts, __uuidof(EnumUnknowns));
					pFlts->Insert(pDocType);
				}
				*a_ppFormatFilters = pFlts.Detach();
			}
			return S_OK;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}
	//STDMETHOD(Save)(IConfig* a_pSaveOptions, IStorageFilter* a_pSaveCopyAsDestination);
	EUndoMode DefaultUndoModeHelper() { return a_tDefaultUndoMode; }
	STDMETHOD(DefaultUndoMode)(EUndoMode* a_peDefaultMode)
	{
		if (a_tDefaultUndoMode == EUMDefault)
			return E_NOTIMPL;
		try
		{
			*a_peDefaultMode = static_cast<T*>(this)->DefaultUndoModeHelper();
			return S_OK;
		}
		catch (...)
		{
			return a_peDefaultMode ? E_UNEXPECTED : E_POINTER;
		}
	}
	STDMETHOD(MaximumUndoSize)(ULONGLONG* /*a_pnMaximumSize*/)
	{
		return E_NOTIMPL;
	}
	STDMETHOD(LocationChanged)(IStorageFilter* /*a_pOldLoc*/)
	{
		return S_FALSE;
	}
	STDMETHOD(RemovingBlock)()
	{
		return S_FALSE;
	}
	STDMETHOD(ComponentFeatureOverride)(BSTR /*a_bstrID*/, REFIID /*a_iid*/, void** /*a_ppFeatureInterface*/)
	{
		return S_FALSE;
	}
	STDMETHOD(ComponentLocationGet)(BSTR /*a_bstrID*/, IStorageFilter* /*a_pThisLoc*/, IStorageFilter** /*a_ppComponentLoc*/)
	{
		return E_NOTIMPL;
	}
	STDMETHOD(ResourcesManage)(EDocumentResourceManager a_eActions, ULONGLONG* a_pValue)
	{
		return E_NOTIMPL;
	}

	IDocumentBase* M_Base() const { return m_pBase; }
	BSTR M_DataID() const { return m_bstrDataID; }
	operator IBlockOperations*() const { return m_pBase; }

private:
	CComPtr<IDocumentBase> m_pBase;
	CComBSTR m_bstrDataID;
};

template<class T, size_t t_nFeatures, IID const* t_apFeatures, class TDocumentTypeCreator, class TBase = CSubjectImpl<CBlockOperationsSimpleImpl<T, IDocument>, IDocumentObserver, ULONG> >
class ATL_NO_VTABLE CDocumentImpl : public TBase
{
public:
	typedef CReadLock<TBase> CDocumentReadLock;
	typedef CWriteLock<TBase> CDocumentWriteLock;

	CDocumentImpl() : m_nChangeFlags(0)
	{
	}

	void AddDocumentChanges(ULONG a_nChanges)
	{
		m_nChangeFlags |= a_nChanges;
	}
	void Fire_NotifyDocument()
	{
		if (m_nChangeFlags)
		{
			Fire_Notify(m_nChangeFlags);
			m_nChangeFlags = 0;
		}
	}
	IStorageFilter* M_Location() const // must be locked externally
	{
		return m_pLocation;
	}

	// IDocument methods
public:
	STDMETHOD(FeaturesGetCount)(ULONG *a_pnCount)
	{
		try
		{
			*a_pnCount = t_nFeatures;
			return S_OK;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}
	STDMETHOD(FeaturesGet)(ULONG a_nIndexFirst, ULONG a_nCount, GUID* a_atFeatures)
	{
		try
		{
			if ((a_nIndexFirst+a_nCount) > t_nFeatures)
				return E_RW_INDEXOUTOFRANGE;

			for (IID const* i = t_apFeatures+a_nIndexFirst; a_nCount != 0; a_nCount--)
			{
				*(a_atFeatures++) = *(i++);
			}

			return S_OK;
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}
	STDMETHOD(QueryFeatureInterface)(REFIID a_iid, void** a_ppFeatureInterface)
	{
		return static_cast<T*>(this)->QueryInterface(a_iid, a_ppFeatureInterface);
	}

	STDMETHOD(LocationGet)(IStorageFilter** a_ppLocation)
	{
		try
		{
			*a_ppLocation = NULL;

			CDocumentReadLock cLock(this);
			if (m_pLocation)
			{
				(*a_ppLocation = m_pLocation)->AddRef();
			}

			return (*a_ppLocation) ? S_OK : E_FAIL;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}
	STDMETHOD(LocationSet)(IStorageFilter* a_pLocation)
	{
		try
		{
			CDocumentWriteLock cLock(this);
			if (m_pLocation != a_pLocation)
			{
				m_pLocation = a_pLocation;
			}

			return S_OK;
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}
	STDMETHOD(IsDirty)()
	{
		return E_NOTIMPL;
	}
	STDMETHOD(SetDirty)(BYTE a_bDirty)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(DocumentCopy)(EDocumentCopyHint a_eHint, BSTR a_bstrPrefix, IDocumentBaseInit* a_pBase)
	{
		return E_NOTIMPL;
		//try
		//{
		//	*a_ppCopy = NULL;
		//	(*a_ppCopy = this)->AddRef();
		//	return S_OK;
		//}
		//catch (...)
		//{
		//	return a_ppCopy ? E_UNEXPECTED : E_POINTER;
		//}
	}

	STDMETHOD(SaveOptionsGet)(IConfig** a_ppSaveOptions, IEnumUnknowns** a_ppFormatFilters, IStorageFilterWindowListener** a_ppWindowListener)
	{
		return E_NOTIMPL;
	}
	STDMETHOD(Save)(IConfig* a_pSaveOptions, IStorageFilter* a_pSaveCopyAsDestination)
	{
		return E_NOTIMPL;
	}

	STDMETHOD(DocumentTypeGet)(IDocumentType** a_ppDocumentType)
	{
		try
		{
			*a_ppDocumentType = TDocumentTypeCreator::Create();
			return *a_ppDocumentType ? S_OK : E_NOTIMPL;
		}
		catch (...)
		{
			return E_POINTER;
		}
	}

	void InternSetLocation(IStorageFilter* a_pLocation)
	{
		// caller must catch exceptios
		CDocumentWriteLock cLock(this);
		// TODO: correct locks
		if (m_pLocation != a_pLocation)
		{
			m_pLocation = a_pLocation;
			AddDocumentChanges(EDCLocation);
		}
	}

private:
	CComPtr<IStorageFilter> m_pLocation;
	ULONG m_nChangeFlags;
};

// checks if document supports all features
inline bool SupportsAllFeatures(ULONG a_nFeaturesSupported, IID const* a_aFeaturesSupported, ULONG a_nFeaturesRequired, IID const* a_aFeaturesRequired)
{
	for (ULONG iReq = 0; iReq != a_nFeaturesRequired; iReq++)
	{
		ULONG iSup;
		for (iSup = 0; iSup != a_nFeaturesSupported && !IsEqualIID(a_aFeaturesRequired[iReq], a_aFeaturesSupported[iSup]); iSup++) ;

		if (iSup == a_nFeaturesSupported)
			return false;
	}
	return true;
}
inline bool SupportsAllFeatures(IDocument* a_pDocument, ULONG a_nCount, IID const* a_aFeaturesRequired)
{
	try
	{
		ULONG nFeatures = 0;
		a_pDocument->FeaturesGetCount(&nFeatures);
		IID* const aSupported = reinterpret_cast<IID*>(_alloca(sizeof(IID)*nFeatures));
		a_pDocument->FeaturesGet(0, nFeatures, aSupported);
		return SupportsAllFeatures(nFeatures, aSupported, a_nCount, a_aFeaturesRequired);
	}
	catch (...)
	{
		return false;
	}
}

template<class T, size_t t_nFeatures, IID const* t_apFeatures, class TDocumentTypeCreator, ULONG t_nPriority = EDPAverage, class TBase = IDocumentFactory>
class CDocumentFactoryImpl : public TBase
{
	// IDocumentFactory methods
public:
	STDMETHOD(DocumentTypeGet)(ULONG a_nCount, const IID* a_aiidRequired, IDocumentType** a_ppDocumentType)
	{
		try
		{
			*a_ppDocumentType = NULL;

			if (!SupportsAllFeatures(t_nFeatures, t_apFeatures, a_nCount, a_aiidRequired))
				return E_NOINTERFACE;

			*a_ppDocumentType = TDocumentTypeCreator::Create();
			return S_OK;
		}
		catch (...)
		{
			return a_ppDocumentType == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
	HRESULT DocumentCreateEx(IStorageFilter* a_pDataSource, BOOL /*a_bForce*/, BSTR a_bstrPrefix, IDocumentBaseInit* a_pBase)
	{
		return static_cast<T*>(this)->DocumentCreate(a_pDataSource, a_bstrPrefix, a_pBase);
	}
	STDMETHOD(DocumentCreate)(ULONG a_nCount, const IID* a_aiidRequired, IStorageFilter* a_pDataSource, BOOL a_bForce, BSTR a_bstrPrefix, IDocumentBaseInit* a_pBase)
	{
		try
		{
			if (!SupportsAllFeatures(t_nFeatures, t_apFeatures, a_nCount, a_aiidRequired))
				return E_NOINTERFACE;

			return static_cast<T*>(this)->DocumentCreateEx(a_pDataSource, a_bForce, a_bstrPrefix, a_pBase);
		}
		catch (...)
		{
			return E_UNEXPECTED;
		}
	}
	STDMETHOD(PriorityGet)(ULONG* a_pnPriority)
	{
		try
		{
			*a_pnPriority = t_nPriority;
			return S_OK;
		}
		catch (...)
		{
			return a_pnPriority == NULL ? E_POINTER : E_UNEXPECTED;
		}
	}
};

#define FEATURES(feats) sizeof(feats)/sizeof(feats[0]), feats

struct CDocumentTypeCreatorNone
{
	static IDocumentType* Create()
	{
		return NULL;
	}
};

template<UINT t_nFilterNameID, UINT t_nTypeNameID, LPCOLESTR t_pszSupportedExtensions, UINT t_nFilterIconID, LPCOLESTR t_pszShellIconPath>
struct CDocumentTypeCreatorWildchars
{
	static IDocumentType* Create()
	{
		size_t nExtensions = 0;
		BSTR* pExtensions = NULL;
		CComBSTR bstrFilter;
		if (t_pszSupportedExtensions != NULL)
		{
			nExtensions = 1;
			size_t i;
			for (i = 0; t_pszSupportedExtensions[i]; ++i)
			{
				if (t_pszSupportedExtensions[i] == L'|')
				{
					++nExtensions;
				}
			}
			pExtensions = new BSTR[nExtensions];
			for (i = 0; i < nExtensions; ++i)
			{
				pExtensions[i] = NULL;
			}
			size_t ii = 0;
			LPCOLESTR psz = t_pszSupportedExtensions;
			for (i = 0; t_pszSupportedExtensions[i]; ++i)
			{
				if (t_pszSupportedExtensions[i] == L'|')
				{
					pExtensions[ii] = ::SysAllocStringLen(psz, t_pszSupportedExtensions+i-psz);
					psz = t_pszSupportedExtensions+i+1;
					++ii;
				}
			}
			pExtensions[ii] = ::SysAllocStringLen(psz, t_pszSupportedExtensions+i-psz);
			for (i = 0; i < nExtensions; ++i)
			{
				if (bstrFilter == NULL)
				{
					bstrFilter = L"*.";
				}
				else
				{
					bstrFilter += L";*.";
				}
				bstrFilter += pExtensions[i];
			}
		}

		TCHAR szModuleName[MAX_PATH] = _T("");
		GetModuleFileName(_pModule->get_m_hInst(), szModuleName, MAX_PATH);
		CT2W cModuleName(szModuleName);
		OLECHAR const* pszModuleName = cModuleName;
		OLECHAR szShellIcon[MAX_PATH+32];
		int iSrc = 0;
		int iDst = 0;
		while (t_pszShellIconPath[iSrc] && iDst < (MAX_PATH+32-1))
		{
			if (0 == wcsncmp(t_pszShellIconPath+iSrc, L"%MODULE%", 8))
			{
				int i = 0;
				while (szModuleName[i] && iDst < (MAX_PATH+32-1))
				{
					szShellIcon[iDst++] = pszModuleName[i++];
				}
				iSrc += 8;
			}
			else
			{
				szShellIcon[iDst] = t_pszShellIconPath[iSrc];
				++iDst;
				++iSrc;
			}
		}
		szShellIcon[iDst] = L'\0';

		CComPtr<IDocumentTypeWildcards> pTmp;
		RWCoCreateInstance(pTmp, __uuidof(DocumentTypeWildcards));
		pTmp->InitEx(
			_SharedStringTable.GetStringAuto(t_nFilterNameID),
			_SharedStringTable.GetStringAuto(t_nTypeNameID),
			nExtensions, pExtensions,
			iDst == 0 ? NULL : CComBSTR(szShellIcon),
			_pModule->get_m_hInst(), t_nFilterIconID,
			bstrFilter);

		for (int i = 0; i < nExtensions; ++i)
			::SysFreeString(pExtensions[i]);
		delete[] pExtensions;

		return pTmp.Detach();
	}
};

class CUndoBlock
{
public:
	CUndoBlock(IDocumentUndo* a_pUndo, ILocalizedString* a_pName = NULL) : m_pUndo(NULL)
	{
		if (m_pUndo)
		{
			if (SUCCEEDED(m_pUndo->StepStart(a_pName)))
				(m_pUndo = a_pUndo)->AddRef();
		}
	}
	CUndoBlock(IDocument* a_pDoc, ILocalizedString* a_pName = NULL) : m_pUndo(NULL)
	{
		CComQIPtr<IDocumentUndo> pUndo(a_pDoc);
		if (pUndo)
		{
			if (SUCCEEDED(pUndo->StepStart(a_pName)))
				m_pUndo = pUndo.Detach();
		}
	}
	~CUndoBlock()
	{
		if (m_pUndo)
		{
			m_pUndo->StepEnd();
			m_pUndo->Release();
		}
	}

private:
	IDocumentUndo* m_pUndo;
};

extern "C"{ // continue: extern "C"{

#endif//__cplusplus

